/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.KnockBacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class EntityHeavyRainSwords
extends EntityAbstractSummonedSword {
    private static final EntityDataAccessor<Boolean> IT_FIRED = SynchedEntityData.m_135353_(EntityHeavyRainSwords.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    long fireTime = -1L;
    int ON_GROUND_LIFE_TIME = 20;
    int ticksInGround = 0;

    public EntityHeavyRainSwords(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setPierce((byte)5);
        CompoundTag compoundtag = this.getPersistentData();
        ListTag listtag = compoundtag.m_128437_("CustomPotionEffects", 9);
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.f_19597_, 20, 10);
        listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
        this.getPersistentData().m_128365_("CustomPotionEffects", (Tag)listtag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IT_FIRED, (Object)false);
    }

    public void doFire() {
        this.m_20088_().m_135381_(IT_FIRED, (Object)true);
    }

    public boolean itFired() {
        return (Boolean)this.m_20088_().m_135370_(IT_FIRED);
    }

    public static EntityHeavyRainSwords createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityHeavyRainSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
    }

    @Override
    public void m_8119_() {
        if (!this.itFired() && this.m_9236_().m_5776_() && this.m_20202_() == null) {
            this.m_7998_(this.m_19749_(), true);
        }
        super.m_8119_();
    }

    public void m_6083_() {
        if (this.itFired() && this.fireTime <= (long)this.f_19797_) {
            this.faceEntityStandby();
            this.m_8127_();
            Vec3 dir = new Vec3(0.0, -1.0, 0.0);
            this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 4.0f, 2.0f);
            this.f_19797_ = 0;
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.canUpdate()) {
            this.m_6075_();
        }
        this.faceEntityStandby();
        if (!this.itFired()) {
            int basedelay = 10;
            this.fireTime = this.f_19797_ + basedelay + this.getDelay();
            this.doFire();
        }
    }

    private void faceEntityStandby() {
        this.m_146884_(this.m_20182_());
        this.m_19915_(this.m_146908_(), -90.0f);
    }

    public void setSpread(Vec3 basePos) {
        double areaSize = 2.5;
        double offsetX = (this.f_19796_.m_188500_() * 2.0 - 1.0) * areaSize;
        double offsetZ = (this.f_19796_.m_188500_() * 2.0 - 1.0) * areaSize;
        this.m_6034_(basePos.f_82479_ + offsetX, basePos.f_82480_, basePos.f_82481_ + offsetZ);
    }

    @Override
    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity targetEntity = p_213868_1_.m_82443_();
        if (targetEntity instanceof LivingEntity) {
            KnockBacks.cancel.action.accept((LivingEntity)targetEntity);
            StunManager.setStun((LivingEntity)targetEntity);
        }
        super.m_5790_(p_213868_1_);
    }

    @Override
    protected void tryDespawn() {
        ++this.ticksInGround;
        if (this.ON_GROUND_LIFE_TIME <= this.ticksInGround) {
            this.burst();
        }
    }
}

